/**@file

 @copyright
  INTEL CONFIDENTIAL
  Copyright 1999 - 2015 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef LEGACY_BIOS_PLATFORM_H_
#define LEGACY_BIOS_PLATFORM_H_

#include <Base.h>
#include <Uefi.h>
#include <SetupVariable.h>
#include <PchAccess.h>
#include <Guid/GlobalVariable.h>
#ifdef AMT_SUPPORT
#include <MeBiosExtensionSetup.h>
#include <Protocol/AmtPolicy.h>
#endif
#include <Protocol/LegacyBiosPlatform.h>
#include <Protocol/PciRootBridgeIo.h>
#include <Protocol/IrqTableInfo.h>
#include <Protocol/Wdt.h>
#include <Protocol/LegacyBiosPlatform.h>
#include <Protocol/PciIo.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Library/UefiRuntimeServicesTableLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/DebugLib.h>
#include <MeChipset.h>
#include <IndustryStandard/Pci22.h>
#include <IndustryStandard/LegacyBiosMpTable.h>
#include <Protocol/GlobalNvsArea.h>

//
// GUIDs for System ROMs to be loaded
//

#define SYSTEM_ROM_FILE_GUID \
{0x1547B4F3, 0x3E8A, 0x4FEF, {0x81, 0xC8, 0x32, 0x8E, 0xD6, 0x47, 0xAB, 0x1A}}

#define TEST_SYSTEM_ROM_FILE_GUID \
{0x472BE2A0, 0x7FEA, 0x450A, {0x90, 0xE8, 0x5F, 0xF8, 0x45, 0xDD, 0xC7, 0x92}}

#define NULL_ROM_FILE_GUID \
{0x00000000, 0x0000, 0x0000, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}

//
// GUIDs for OEM INT15 HOOK ROMs to be loaded
//

//
// INT15 5F35h - Boot Display Device Hook BIN GUID {A673005A-69F6-4597-8AF9-7AACA0039296}
//
#define OEM_INT_15_BOOT_DISPLAY_GUID \
{0xa673005a, 0x69f6, 0x4597, {0x8a, 0xf9, 0x7a, 0xac, 0xa0, 0x3, 0x92, 0x96}}

//
// INT15 5F40h - Boot Panel Type Hook BIN GUID {8D1AE715-7F82-449d-A26C-62AC650AF73F}
//
#define OEM_INT_15_PANEL_TYPE_GUID \
{0x8d1ae715, 0x7f82, 0x449d, {0xa2, 0x6c, 0x62, 0xac, 0x65, 0xa, 0xf7, 0x3f}}

//
// INT15 5F34h - Boot Panel Fitting Hook BIN GUID {E974833F-A4AE-4e39-BE37-8B6780DFAD01}
//
#define OEM_INT_15_PANEL_FITTING_GUID \
{0xe974833f, 0xa4ae, 0x4e39, {0xbe, 0x37, 0x8b, 0x67, 0x80, 0xdf, 0xad, 0x1}}

//
// INT15 5F36h - Boot TV set mode Hook BIN GUID {E9F05D70-9946-4ab9-A7F7-070E92C415BD}
//
#define OEM_INT_15_BOOT_TVMODE_GUID \
{0xe9f05d70, 0x9946, 0x4ab9, {0xa7, 0xf7, 0x7, 0xe, 0x92, 0xc4, 0x15, 0xbd}}

//
// Int15 5F14h - Get Misc bios status Hook BIN GUID {D024BCD2-59EA-48ac-A17F-B3221EC23A11}
//
#define OEM_INT_15_GET_MISC_GUID \
{0xd024bcd2, 0x59ea, 0x48ac, {0xa1, 0x7f, 0xb3, 0x22, 0x1e, 0xc2, 0x3a, 0x11}}

#define PXE_BASE_OPTION_ROM_FILE_GUID \
{0x6f2bc426, 0x8d83, 0x4f17, {0xbe, 0x2c, 0x6b, 0x1f, 0xcb, 0xd1, 0x4c, 0x80}}

#define AMT_SOL_LEGACY_VGA_REDIR_ROM_FILE_GUID \
{0x346b4547, 0xfef7, 0x49d4, {0x9a, 0x4a, 0xf6, 0x66, 0x82, 0x5e, 0x25, 0xb7}}

#define MAX_BIOS_VERSION_SIZE     32

#define MAX_IRQ_PRIORITY_ENTRIES  7

#define INITIAL_PEG_BUS_NUMBER    0x01
#define INITIAL_PCI_BUS_NUMBER    0x02

#define PIRQN                     0x00  // PIRQ Null
#define PIRQA                     0x3100
#define PIRQB                     0x3101
#define PIRQC                     0x3102
#define PIRQD                     0x3103
#define PIRQE                     0x3104
#define PIRQF                     0x3105
#define PIRQG                     0x3106
#define PIRQH                     0x3107



//
// The following IRQs are always in use by legacy devices:
//     0  = System Timer
//    2  = 8259 PIC
//    8  = RTC
//    9  = SCI Interrupt (It may be used, we choose not to)
//    13 = Co-processor Error
//
// The following may be in use by legacy devices:
//    1  = If using PS/2 Keyboard
//    3  = If COMx Port Enabled and IRQ = 3
//    4  = If COMx Port Enabled and IRQ = 4
//    5  = If LPT Port Enabled and IRQ = 5
//    6  = If FDC Enabled
//    7  = If LPT Port Enabled and IRQ = 7
//    12 = If using PS/2 Mouse
//    14 = Primary IDE (If populated and in Compatibility Mode)
//    15 = Secondary IDE (If populated and in Compatibility Mode)
//

//
// 1000 1100 1000 0000
//

#define IRQ_MASK                  0x8c80
#define IRQ_NULL                  0x0000

#define BUS_UPDATE_FLAG           0xFF


#define MAX_CONTROLLER            2
#define PRIMARY_COMMAND_BAR       0x10
#define PRIMARY_CONTROL_BAR       0x14
#define SECONDARY_COMMAND_BAR     0x18
#define SECONDARY_CONTROL_BAR     0x1c
#define BUS_MASTER_BAR            0x20

UINT8   RomCount;
UINT32  ClassCode;
UINT8   BaseCode;
UINT8   SubClassCode;
UINT8   InterfaceCode;
UINT16  ReqVid;
UINT16  ReqDid;
UINT16  ReqSvId;
UINT16  ReqSysId;
UINT16  DeviceIndex;

#define KBC_C_PORT                0x64
#define KBC_D_PORT                0x60
#define KBC_STATUS_IBF            0x02  // Bit 1
#define KBC_STATUS_OBF            0x01  // Bit 0
#define KEYBOARD_CONTROLLER_COMMAND_BYTE_READ   0x20
#define KEYBOARD_CONTROLLER_COMMAND_BYTE_WRITE  0x60
#define KEYBOARD_INTERRUPT_ENABLE               0x01  // Bit 0
#define KEYBOARD_DISABLE                        0x10  // Bit 4

//
// Type declarations
//

#pragma pack(1)
//
// Define structures for GetOemIntData
//  Note:
//    OemIntDataElenent is an array of structures from 0 to Count-1.
//    RawData is an array of bytes from 0 to RamDataLength-1.
//
typedef struct {
  UINT16  Int;
  UINT16  Ax;
  UINT32  RawDataLength;
  UINT8   RawData[1];
} EFI_OEM_INT_DATA_ELEMENT;

typedef struct {
  UINT16                    Count;
  EFI_OEM_INT_DATA_ELEMENT  OemIntDataElement[1];
} EFI_OEM_INT_DATA;
#pragma pack()

typedef struct {
  EFI_GUID  FileName;
  UINTN     Valid;
} SYSTEM_ROM_TABLE;

typedef struct {
  EFI_GUID  FileName;
  BOOLEAN   Valid;
} SERVICE_ROM_TABLE;

#pragma pack(1)

typedef struct {
  UINT32  SmiTableIdentifier;
  UINT8   Checksum;
  UINT8   Length;
  UINT8   Type;
  UINT8   Revision;
  UINT8   LocationOfThePointer;
  UINT32  Address;
  UINT32  FlashPartSize;
  UINT16  ErrorCode;
  UINT32  PhysPtrMailBox;
  UINT16  ScratchPad;
  UINT16  SmiIoAddress;
  UINT8   SmiAndMask;
  UINT8   SmiOrMask;
  UINT8   SmiIoAddressTerminator;
  UINT8   IbiosiStr[8];
  UINT8   BiosId[12];
} PORT_MAPPER_TABLE;

#pragma pack()

typedef struct {
  UINT16  Type;
  UINT16  Flags;
  UINT32  *BootHandler;
  CHAR8   *DeviceString;
  UINT32  Reserved;
} IPL_TABLE;

typedef struct {
  UINT32                            Signature;

  EFI_HANDLE                        Handle;
  EFI_LEGACY_BIOS_PLATFORM_PROTOCOL LegacyBiosPlatform;

  EFI_HANDLE                        ImageHandle;
  EFI_PCI_ROOT_BRIDGE_IO_PROTOCOL   *PciRootBridgeIo;

  IRQ_TABLE_INFO_PROTOCOL           *IrqTableInfo;
  BOOLEAN                           PciAutoDetect;
} LEGACY_BIOS_PLATFORM_INSTANCE;

#pragma pack()
#define LEGACY_BIOS_PLATFORM_INSTANCE_SIGNATURE SIGNATURE_32 ('P', 'B', 'I', 'O')

#define LEGACY_BIOS_PLATFORM_INSTANCE_FROM_THIS(this) \
  CR (this, \
      LEGACY_BIOS_PLATFORM_INSTANCE, \
      LegacyBiosPlatform, \
      LEGACY_BIOS_PLATFORM_INSTANCE_SIGNATURE \
      )

//#define EFI_COMPATIBILITY16_TABLE_SIGNATURE SIGNATURE_32 ('I', 'F', 'E', '$')

//
// @todo: This entry maybe changed to PCD in future and wait for
//         redesign of BDS library
//
#define MAX_BBS_ENTRIES 0x100

#endif
